RollerMission = {};
RollerMission.NAME = "rollerMission";

RollerMission.metadata = {
	interface = "FS25 ...", --new
	title = "Rolling Contracts",
	notes = "Dieser Mod generiert Walzen Aufträge.",
	author = "(by HappyLooser)",
	version = "1.0.0.0",	
	build = 2,
	datum = "30.05.2022",
	update = "05.06.2025",
	debugPrint = false, 
	discord = "HappyLooser Modding",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};	

local RollerMission_mt = Class(RollerMission, AbstractFieldMission);
InitObjectClass(RollerMission, "RollerMission");

function debugPrint(text, ...)
	if RollerMission.metadata.debugPrint then
		Logging.info(text,...)
	end
end

function RollerMission.registerXMLPaths(schema, key)
	RollerMission:superClass().registerXMLPaths(schema, key);
	schema:register(XMLValueType.INT, key .. "#rewardPerHa", "Reward per ha");
end;

function RollerMission.registerSavegameXMLPaths(schema, key)
	RollerMission:superClass().registerSavegameXMLPaths(schema, key)
	schema:register(XMLValueType.INT, key .. "#targetRollerLevel", "Target roller level")
end

function RollerMission.new(isServer, isClient, customMt)
	local title = g_i18n:getText("contract_field_roller_title"); 
	local description = g_i18n:getText("contract_field_roller_description");
	local self = AbstractFieldMission.new(isServer, isClient, title, description, customMt or RollerMission_mt);
	self.workAreaTypes = {
		[WorkAreaType.ROLLER] = true;
	}
	self.targetRollerLevel = nil;
	return self;
end;

function RollerMission:init(field, targetRollerLevel)
	self.targetRollerLevel = targetRollerLevel;
	return RollerMission:superClass().init(self, field);
end;

function RollerMission:createModifier()	
	local mapId, firstChannel, numChannels = g_currentMission.fieldGroundSystem:getDensityMapData(FieldDensityMap.GROUND_TYPE);
	local levelState = FieldGroundType.getValueByType(FieldGroundType.ROLLER_LINES);
	self.completionModifier = DensityMapModifier.new(mapId, firstChannel, numChannels, g_terrainNode);
	self.completionFilter = DensityMapFilter.new(self.completionModifier);
	self.completionFilter:setValueCompareParams(DensityValueCompareType.EQUAL, levelState);	
end;

function RollerMission:getFieldFinishTask()
	self.field:getFieldState().rollerLevel = 1;	
	local fieldState = self.field:getFieldState();
	debugPrint("f%s, growth %d, spray %s, sprayType %s, plow %s, lime %s, weed %s, roller %s, /getFieldFinishTask",
			self.field.farmland.name, fieldState.growthState, fieldState.sprayLevel, fieldState.sprayType, fieldState.plowLevel, fieldState.limeLevel, fieldState.weedState, fieldState.rollerLevel)
		
	return RollerMission:superClass().getFieldFinishTask(self);
end;

function RollerMission:getRewardPerHa()
	return g_missionManager:getMissionTypeDataByName(RollerMission.NAME).rewardPerHa;
end;

function RollerMission:getMissionTypeName()
	return RollerMission.NAME;
end;

function RollerMission:validate(event)
	if RollerMission:superClass().validate(self, event) then
		return (self:getIsFinished() or RollerMission.isAvailableForField(self.field, self)) and true or false;
	else
		return false;
	end;
end;

function RollerMission.loadMapData(xmlFile, key, baseDirectory)
	g_missionManager:getMissionTypeDataByName(RollerMission.NAME).rewardPerHa = xmlFile:getFloat(key .. "#rewardPerHa", 1200);
	return true;
end;

function RollerMission.tryGenerateMission()
	if RollerMission.canRun() then
		local field = g_fieldManager:getFieldForMission();
		if field == nil then
			return;
		end;
		if field.currentMission ~= nil then
			return;
		end;
		if not RollerMission.isAvailableForField(field, nil) then
			return;
		end;
		local rollerLevel = field:getFieldState().rollerLevel + 1
		local mission = RollerMission.new(true, g_client ~= nil);
		if mission:init(field, rollerLevel) then
			mission:setDefaultEndDate();
			return mission;
		end;
		mission:delete();
	end;
	return nil;
end;

function RollerMission.isAvailableForField(field, mission)
	if mission == nil then
		local fieldState = field:getFieldState();
		if not fieldState.isValid then
			return false;
		end;
		if field.grassMissionOnly then
			return false;
		end;
		--if field.groundType ~= FieldGroundType.SOWN then
		--	return false;
		--end;
		debugPrint("f%s, growth %d, spray %s, sprayType %s, plow %s, lime %s, weed %s, roller %s, /isAvailableForField",
			field.farmland.name, fieldState.growthState, fieldState.sprayLevel, fieldState.sprayType, fieldState.plowLevel, fieldState.limeLevel, fieldState.weedState, fieldState.rollerLevel)
		if fieldState.rollerLevel == nil or fieldState.rollerLevel > 0 then 
			return false;
		end;
		local fruitIndex = fieldState.fruitTypeIndex;
		if fruitIndex == FruitType.UNKNOWN then
			return false;
		end;
		local growthState = fieldState.growthState;
		local fruitDesc = g_fruitTypeManager:getFruitTypeByIndex(fruitIndex);
		if fruitDesc == nil or not fruitDesc.needsRolling then return false;end;
		if fruitDesc:getIsCatchCrop() or growthState > 1 then
			return false;
		end;
	end;
	return true;
end;

function RollerMission.canRun()
	local data = g_missionManager:getMissionTypeDataByName(RollerMission.NAME);
	if data.numInstances >= data.maxNumInstances then
		return false;
	else
		return not g_currentMission.growthSystem:getIsGrowingInProgress();
	end;
end;
g_missionManager:registerMissionType(RollerMission, RollerMission.NAME, 4);
print("---register ".. tostring(RollerMission.metadata.title).. " ".. tostring(RollerMission.metadata.version).. "(#".. tostring(RollerMission.metadata.build).. ") ".. tostring(RollerMission.metadata.author).. "---")